unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls,
  UConsts, USg;

type

	// w C++
   // enum MAlign {toLeft, toCenter, toRight};
   MAlign = (toLeft, toCenter, toRight);

  TMainForm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    sg: TStringGrid;
    procedure sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Image1Click(Sender: TObject);

  private
	 mSelected : Boolean;

	 procedure DrawRectGrid(Rect : TRect);

	 procedure MyAlign(Canvas : TCanvas; var txt : String; Rect : TRect; const jak_wyrownac : MAlign);


	 procedure Przypisz_lp();    

  public
	 procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.Image1Click(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   mSelected := false;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);

   ActiveControl := sg;
end;

procedure TMainForm.Przypisz_lp();
var
	ARow          : Integer;
   ACol          : Integer;
   ilosc_wierszy : Integer;
   lp            : Integer;

begin
	ARow          := 0;
   ACol          := 0;
   ilosc_wierszy := 0;
   lp            := 0;
	ARow          := 0;

   ilosc_wierszy := sg.RowCount;

	for ARow := 1 to ilosc_wierszy-1 do
	begin
   	sg.Cells[ACol, ARow] := IntToStr(ARow);
   end;

   sg.Invalidate();
end;

procedure TMainForm.sgSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
begin
	mSelected := true;
end;

procedure TMainForm.DrawRectGrid(Rect: TRect);
begin
	if mSelected then
   begin
		sg.Invalidate();
		mSelected := false;
	end;

	sg.Canvas.Brush.Style := bsClear;
	sg.Canvas.Pen.Color   := clBlack;
	sg.Canvas.Pen.Width   := 2;
	sg.Canvas.Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
end;

procedure TMainForm.MyAlign(Canvas: TCanvas; var txt: String; Rect: TRect; const jak_wyrownac: MAlign);
var
	i : Integer;
	j : Integer;


begin
	i := (Rect.Right - Rect.Left - Canvas.TextWidth(txt)) div 2;
	j := (Rect.Bottom - Rect.Top - Canvas.TextHeight(txt)) div 2;

	(*
	if jak_wyrownac <> toDefault then
	begin
		Canvas.Brush.Color := Canvas.Brush.Color;
	end;
   *)

	Canvas.FillRect(Rect);

	if jak_wyrownac = toCenter then
	begin
		Canvas.TextOut(Rect.Left + i, Rect.Top + j, txt);
   end;

	if jak_wyrownac = toRight then
   begin
   	Canvas.TextOut(Rect.Right - Canvas.TextWidth(txt) - 3, Rect.Top + j, txt);
	end;

	if jak_wyrownac = toLeft then
   begin
		Canvas.TextOut(Rect.Left + 2, Rect.Top + j, txt);
	end;
end;

procedure TMainForm.sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
var
	inny_kolor  : Boolean;
	txt         : String;
	x           : Integer;
	y           : Integer;
	kolor       : TColor;

begin
	inny_kolor := false;
	txt        := '';
	x          := 0;
	y          := 0;

	if (ARow = 0) or (ACol = 0) then
	begin
   	exit;
	end;

	// co drugi rzd w innym kolorze
	inny_kolor := (ARow mod 2) = 0;

	if gdFocused in State then
	begin
		DrawRectGrid(Rect);
	end;

	if inny_kolor then
	begin
		if not (gdFocused in State) then
		begin
			txt := sg.Cells[ACol, ARow];

			// kolor niestandardowy
			sg.Canvas.Brush.Color := TColor($00D6EAEF);
			sg.Canvas.FillRect(Rect);

			x := Rect.Left + 2;
			y := (Rect.Top + Rect.Bottom - sg.Canvas.TextHeight(txt)) div 2;
			sg.Canvas.TextOut(x, y, txt);
		end;
	end;

	// wyrwnanie zawartoci komrek
	if ACol = colMiasto then
   begin
   	if not (gdFocused in State) then
		begin
      	txt := sg.Cells[ACol, ARow];
			MyAlign(sg.Canvas, txt, Rect, toCenter);
		end;
   end
   else begin
      if ACol = colZarobek then
      begin
         if not (gdFocused in State) then
         begin
            txt := sg.Cells[ACol, ARow];
            MyAlign(sg.Canvas, txt, Rect, toRight);
         end;
      end
      else begin
	   	if not (gdFocused in State) then
   	   begin
      		txt := sg.Cells[ACol, ARow];
         	MyAlign(sg.Canvas, txt, Rect, toLeft);
	      end;
      end;
   end;
end;

end.

